# 名医大赏设计文档



## 一、数据库设计

**名医大赏报名表**

api_famous_doctors_registrationer

| 字段        | 类型     | 默认值 | 是否为null | 解释                             |
| ----------- | -------- | ------ | ---------- | -------------------------------- |
| doctor_id   | string   |        | 否         | 医生id                           |
| doctor_type | int      |        | 否         | 医生或者机构                     |
| is_online   | bool     | 1      | 否         | 是否有效                         |
| create_time | datetime |        | 否         | 创建时间                         |
| update_time | datetime |        | 否         | 修改时间                         |
| is_deleted  | bool     | 0      | 否         | 是否删除                         |
| version     | String   | 0      | 否         | 版本（例如2020年名医大赏202010） |



**名医大赏投票记录表**

api_famous_doctors_vote

| 字段        | 类型     | 默认值 | 是否为null | 解释     |
| ----------- | -------- | ------ | ---------- | -------- |
| register_id | int      |        | 否         | 报名id   |
| item_id     | int      |        | 否         | 项目id   |
| user_id     | int      |        | 否         | 用户id   |
| platform    | string   | iPhone | 否         | 平台     |
| update_time | datetime |        | 否         | 修改时间 |
| is_deleted  | bool     | 0      | 否         | 是否删除 |
| create_time | datetime |        | 否         | 创建时间 |



**名医大赏报名项目表**

api_famous_doctors_registeritem

| 字段        | 类型     | 默认值 | 是否为null | 解释                       |
| ----------- | -------- | ------ | ---------- | -------------------------- |
| register_id | int      |        | 否         | 报名id                     |
| item_id     | int      |        | 否         | 项目id                     |
| vote_count  | int      | 0      | 否         | 票数统计                   |
| final_count | int      | 0      | 否         | 读取数量(真实数、灌水数量) |
| update_time | datetime |        | 否         | 修改时间                   |
| is_deleted  | bool     | 0      | 否         | 是否删除                   |
| create_time | datetime |        | 否         | 创建时间                   |



**名医大赏领奖表**

api_famous_doctors_reward

| 字段        | 类型     | 默认值 | 是否为null | 解释                            |
| ----------- | -------- | ------ | ---------- | ------------------------------- |
| user_id     | int      |        | 否         | 报名id                          |
| reward_type | int      | 1      | 否         | 奖励类型（1：美分 2：折扣券）   |
| create_time | datetime |        | 否         | 票数统计                        |
| reward      | string   |        | 否         | {"des":"描述", "prize": "奖励"} |
| version     | string   | 0      | 否         | 名医大赏版本（如202010）        |



**后台灌水记录表**

api_famous_doctors_canvass

| 字段        | 类型     | 默认值 | 是否为null | 解释                            |
| ----------- | -------- | ------ | ---------- | ------------------------------- |
| admin_user_id     | int      |        | 否         | 后台管理员user_id                         |
| register_id | int      |        | 否         | 报名id   |
| item_id |   int    |       | 否        | 类目id                        |
| add_num      | int   |    0    | 否         | 灌水票数    |
| create_time | datetime |        | 否         | 创建时间                |

**名医大赏机构入驻表**
api_famous_doctors_append
| 字段         | 类型     | 默认值         | 是否为null | 解释         |
| ------------ | -------- | -------------- | ---------- | ------------ |
| address      | string   |                | 否         | 地址         |
| append_type  | int      | 1              | 否         | 入驻类型     |
| tel_phone    | str      |                | 否         | 联系电话     |
| version      | str      | 本期默认202010 | 否         | 名医大赏版本 |
| created_time | datetime |                | 否         | 创建时间     |
| updated_time | datetime |                | 否         | 更新时间     |


## 二、rpc接口设计

##三、时序图
```sequence
title:2020名医大赏
participant 用户
participant 报名
participant 入驻
participant 分享
participant 投票
participant 领奖
用户->报名:1.点击链接进入报名
报名-->用户:2.显示报名页面
用户->报名:3.搜索医生/机构,报名
报名->报名:3.1 医生是否存在
报名->入驻:3.1.1不存在,点击入驻
入驻->入驻:3.1.2 审核是否成功
入驻-->报名:3.1.3入驻审核成功,重新搜索，进入报名
报名-->用户:3.2显示医生信息
用户->报名:3.3点击报名
报名->报名:3.3.1判断是否已经报过名
报名->分享:4.报名成功,进入分享页面
分享-->用户:5.展示海报
用户->投票:6.用户投票
投票->投票:6.1判断投票次数是否到达上限
投票-->用户:7.taost提示：投票成功，送您xxx奖励
用户->领奖:8.点击领奖
领奖->领奖:8.1 判断活动是否结束与用户投票的医生是否入围与是否领过奖
领奖-->用户:9.恭喜抽中xxx美分
```




