# coding: utf-8

from datetime import datetime

from api.models.app_config import AppConfig

from rpc.decorators import bind


@bind("api/app/v1/configs")
def get_app_config_with_key_v1(config_key):
	# 可以根据config_key 查询配置
	now_time = datetime.now()
	app_config = AppConfig.objects.filter(
		key=config_key,
		is_online=True,
		online_time__lte=now_time,
		offline_time__gt=now_time,
	).first()

	result = {}
	if app_config:
		result["name"] = app_config.name
		result["key"] = app_config.key
		result["value"] = app_config.value
		result["value_type"] = app_config.value_type
		result["is_online"] = app_config.is_online
		result["online_time"] = app_config.online_time.strftime("%Y-%m-%d %H:%M:%S")
		result["offline_time"] = app_config.offline_time.strftime("%Y-%m-%d %H:%M:%S")
	return result
