#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from django.conf import settings

from api import BDTransfer
from api.models import BDTransferWillingProject, BDTransferWebKefu, to_dict
from gm_types.gaia import TRANSFER_SOURCE
from rpc.decorators import bind

@bind("api/bd_transfer/record")
def record_bd_transfer_info(wechat_number, phone, content='', source=TRANSFER_SOURCE.OTHERS):
    """
    记录用户在免费咨询页面，填写的数据
    :return:
    """
    result = {
        "status": False  # 写库状态
    }

    wechat_exist = BDTransfer.objects.filter(wechat=wechat_number).exists()

    user_phone_exist = False
    if phone:
        user_phone_exist = BDTransfer.objects.filter(user_phone=phone).exists()

    if wechat_exist or user_phone_exist:
        return result

    # 周铭的账号 creator
    obj, created = BDTransfer.objects.get_or_create(wechat=wechat_number, user_phone=phone, creator='23911085')
    result['status'] = created

    if created:
        obj.source = source
        obj.save(update_fields=['source'])
        _ = BDTransferWillingProject.objects.create(bdtransfer=obj, comment=content,
                                                    tag_id=settings.MESSAGE_ASK_REFERRAL_RECORD_TAG_ID)

    return result


@bind("api/bdtransfer/kefu/pc")
def get_pc_bdtransfer_kefu_info():
    return [to_dict(_) for _ in BDTransferWebKefu.objects.filter(is_online=True).all()]
