from api.services.pop_windows import PopWindow
from rpc.decorators import bind


@bind("api/face_app/cache_pop_windows")
def cache_pop_windows(device_id, pop_type, pop_windows):

    pw = PopWindow(device_id=device_id, pop_type=pop_type)
    pw.cache_pop_windows(pop_windows=pop_windows)


@bind("api/face_app/get_pop_windows")
def get_pop_windows(device_id, pop_type):

    pw = PopWindow(device_id=device_id, pop_type=pop_type)
    return pw.get_pop_windows()
