# -*- coding:utf-8 -*-


from rpc.tool.log_tool import logging_exception
from gm_types.gaia import ACTIVITY_TYPE_ENUM, COUPON_TYPES

from api.models import ServiceVideo, Special


def get_service_header_pic_info(service_obj):
    '''
    获取美购详情页头图
    规则: 如果有视频, 则视频放在首位, 之后放置配置图片
    :return:
    '''
    header_pic = [{'video_url': '', 'pic': service_obj.image_header}]
    supplement_images = service_obj.get_supplement_images()
    for si in supplement_images:
        header_pic.append({'video_url': '', 'pic': si})
    data_video = ServiceVideo.objects.filter(service=service_obj.id)
    if data_video:
        video_info = data_video[0].get_video_info()
        header_pic[0]['video_url'] = video_info.get('video_url')
    return header_pic[:6]


def get_show_special_info(service_obj):
    '''
    美购详情页外露专场信息
    :param service_obj:
    :return: {
        special_id:
        special_info:
        is_new_special:
    }
    '''
    special_list, seckill_list = [], []
    special_info_dict = service_obj.get_can_sell_item_ids_and_current_special_info()
    for siid, sp_info in special_info_dict.items():
        if not sp_info.get('id'):
            continue

        if sp_info and sp_info.get('activity_type') == ACTIVITY_TYPE_ENUM.SECKILL:
            seckill_list.append(sp_info['id'])
        else:
            # special_list.append(sp_info['id'])  暂时先隐藏
            pass

    data = {}
    if len(seckill_list) > 0:
        data['special_id'] = max(seckill_list)
        s = Special.objects.get(id=data['special_id'])
        data['special_info'] = s.title
        data['is_seckill'] = s.is_seckill
        data['is_new_special'] = False
        data['special_seckill_type'] = s.seckill_type
    elif len(special_list) > 0:
        data['special_id'] = max(special_list)
        s = Special.objects.get(id=data['special_id'])
        data['special_info'] = s.title
        data['is_new_special'] = s.is_new_special
        data['is_seckill'] = s.is_seckill
        data['special_seckill_type'] = ''
    else:
        data['special_id'] = ''
        data['special_info'] = ''
        data['is_new_special'] = False
        data['is_seckill'] = False
        data['special_seckill_type'] = ''

    return data

def calcate_sku_discount_price(sku_info, user=None):

    sku_info = sku_info or {}
    normal_sku_list = sku_info.get('normal_sku_list', [])
    groupbuy_sku_list = sku_info.get('groupbuy_sku_list', [])
    for n_sku in normal_sku_list:
        fill_discount_price(n_sku, user=user)
        fill_discount_price(n_sku.get('multibuy'), user=user)
    for g_sku in groupbuy_sku_list:
        fill_discount_price(g_sku, is_groupbuy=True, user=user)


def fill_discount_price(sku_price, is_groupbuy=False, user=None, is_login=True):
    try:
        if not sku_price:
            return {}

        from api.view.coupon import calculate_preferential_price

        price_str = is_groupbuy and 'groupbuy_price' or 'gengmei_price'
        groupbuy_price_id = is_groupbuy and sku_price['price_id'] or None
        total_price = sku_price[price_str]
        pre_payment_price = sku_price['pre_payment_price']
        final_price = total_price - pre_payment_price
        price = {
            'total_price': total_price,
            'pre_price': pre_payment_price,
            'final_price': final_price,
        }
        discount_price, pre_discount_value, last_discount_value = calculate_preferential_price(
            user, sku_price['service_id'], sku_price['service_item_id'], groupbuy_price_id, None, price, is_login)
        result = {}
        result['discount_price'] = discount_price
        result['pre_coupon_deduction'] = pre_discount_value
        result['last_coupon_deduction'] = last_discount_value
        result['can_discount'] = discount_price < total_price
        sku_price.update(result)
        return result
    except Exception as e:
        logging_exception()
        return {}
