# coding=utf-8
import tablib
from celery import shared_task
from email.header import make_header
from api.tasks.export_maidan_order_task import get_mail
from rpc.tool.log_tool import info_logger


@shared_task
def return_export_excel_phone_leads(to_user_email, result):
    """
    电话线索导出
    :param to_user_email:
    :return:
    """
    info_logger.info(u'导出开始')
    dt = tablib.Dataset()
    dt.headers = (u'日期', u'线索任务ID', u'机构ID', u'机构名称', u'商户等级',
                  u'所属大区', u'所属城市', u'对应商务名', u'留电虚拟号',
                  u'留电时间', u'沟通状态')

    for send in result:
        dt.append((
            send.setdefault('created_time'),
            send.setdefault('id'),
            send.setdefault('hospital_id'),
            send.setdefault('hospital_name'),
            send.setdefault('merchant_level'),
            send.setdefault('region'),
            send.setdefault('city'),
            send.setdefault('name'),
            send.setdefault('virtual_phone'),
            send.setdefault('created_time'),
            send.setdefault('status'),
        ))

    body = ''
    info_logger.info(u'导出结束')
    file_name = make_header([('导出电话线索', 'utf-8')]).encode('utf-8')
    get_mail(file_name, body, to_user_email, dt).send()