# -*- coding: utf-8 -*-
from gm_types.error import ERROR
from gm_types.gaia import USER_ACCOUNT_TYPE, LOGIN_AUTH_TYPE

from api import Person
from api.util.user_util import UserRegister
from rpc.decorators import bind
from rpc.exceptions import GaiaRPCFaultException

uri_pre = 'api/call_center/account/'
@bind(uri_pre + 'get_or_create_user')
def get_or_create_user(is_staff, person_id, tracking_id=None, channel=None):
    if is_staff:
        if not person_id:
            raise GaiaRPCFaultException(ERROR.INVALID_PARAMS,
                                        'person_id不能为空',
                                        None)
        person = Person.objects.filter(id=person_id).first()
        return {'user_id': person.user_id if person else None,
                'is_created': False}
    if not tracking_id:
        raise GaiaRPCFaultException(ERROR.INVALID_PARAMS,
                                    'tracking_id不能为空',
                                    None)

    user_obj = UserRegister.gen_new_user(account_id=tracking_id,
                                  account_type=USER_ACCOUNT_TYPE.CALL_CENTER,
                                  extra_info=None,
                                  third_info=None,
                                  _auth_type=LOGIN_AUTH_TYPE.CALL_CENTER)
    return {'user_id': user_obj.id if user_obj else None,
            'is_created': bool(user_obj)}





