# coding: utf-8

import json

import redis
from agile.services.tag import (get_all_tag_v3_first_demands, get_all_tag_v3_first_solutions,
                                get_all_tag_v3_positions, get_all_tag_v3_second_demands,
                                get_all_tag_v3_second_solutions)
from django.conf import settings
from django.core.management.base import BaseCommand

redis_client = None
try:
    redis_client = redis.StrictRedis.from_url(settings.DORIS_URL)
except Exception as e:
    print(e)


class Command(BaseCommand):
    """
    同步所有一二级标签，一二级诉求，部分等到redis
    """
    def handle(self, *args, **options):
        print("start")

        redis_key = "doris:search:tag_v3:related:all"
        res = json.dumps({
            "first_demands": get_all_tag_v3_first_demands(),
            "second_demands": get_all_tag_v3_second_demands(),
            "first_solutions": get_all_tag_v3_first_solutions(),
            "second_solutions": get_all_tag_v3_second_solutions(),
            "positions": get_all_tag_v3_positions()
        })
        redis_client.set(redis_key, res)

        # data = redis_client.get(redis_key)
        # json.loads(data)

        print("end")
