# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models
from gm_types.poseidon import PromotionPriority, PromotionStatus, VisualUnitRelatedServiceType, CommodityAuditStatus, \
    UnitType
from django.conf import settings

class ServiceStat(models.Model):
    class Meta:
        app_label = 'doris'
    stat_date = models.CharField(max_length=8, verbose_name=u'日期', null=False)
    query = models.CharField(max_length=50, verbose_name=u'搜索关键词', null=False)
    service_id = models.CharField(db_index=True, max_length=50, verbose_name=u'美购id', null=False)
    pv = models.IntegerField(default=0, verbose_name='pv')
    uv = models.IntegerField(default=0, verbose_name='uv')
    max_pv = models.IntegerField(default=0, verbose_name='max_pv')


class SubmissionCommodity(models.Model):
    class Meta:
        verbose_name = "提报的商品"
        db_table = "submission_commodity"
        app_label = "poseidon"

    objects = models.Manager().db_manager(using=settings.POSEIDON_DB_NAME)
    id = models.AutoField(verbose_name="主键", primary_key=True, db_column="id")
    create_time = models.DateTimeField(
        verbose_name="创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name="更新时间", auto_now=True, db_column="update_time"
    )
    promotion_id = models.IntegerField(verbose_name="促销活动id", null=False)
    submission_id = models.IntegerField(verbose_name="提报id", null=False)
    commodity_id = models.IntegerField(verbose_name="SKU商品id", null=False)
    service_id = models.IntegerField(verbose_name="SPU商品id", null=False)
    giveaway = models.IntegerField(verbose_name="是否是赠品", null=False, default=0)
    deleted = models.IntegerField(verbose_name="是否删除", null=False, default=0)
    activity_price = models.FloatField(
        verbose_name="活动价", null=False, default=0
    )
    advance_discount = models.FloatField(
        verbose_name="预付款抵扣", null=False, default=0
    )
    final_discount = models.FloatField(
        verbose_name="尾款抵扣", null=False, default=0
    )
    advance_payment = models.FloatField(
        verbose_name="预付款", null=False, default=0
    )
    final_payment = models.FloatField(verbose_name="尾款", null=False, default=0)
    promotion_type = models.CharField(
        verbose_name="活动类型", null=False, default="", max_length=64)
    is_valid = models.IntegerField(verbose_name="是否有效（策略数据同步冗余字段）", null=False, default=0)


class Submission(models.Model):
    class Meta:
        verbose_name = "提报记录"
        db_table = "submission"
        app_label = "poseidon"

    objects = models.Manager().db_manager(using=settings.POSEIDON_DB_NAME)
    id = models.AutoField(verbose_name="主键", primary_key=True, db_column="id")
    create_time = models.DateTimeField(
        verbose_name="创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name="更新时间", auto_now=True, db_column="update_time"
    )
    promotion_id = models.IntegerField(verbose_name="促销活动id", null=False)
    merchant_id = models.IntegerField(
        verbose_name="商户id", null=False, default=0
    )
    audit_status = models.IntegerField(
        verbose_name="审核状态",
        null=False,
        choices=CommodityAuditStatus.choices,
        default=CommodityAuditStatus.UN_AUDITED
    )
    audit_comment = models.CharField(
        verbose_name="审核意见", null=False, default="", max_length=64
    )
    inventory = models.IntegerField(verbose_name="库存", null=False, default=0)
    purchase_limitation = models.IntegerField(
        verbose_name="活动每人限购", null=False, default=0, help_text="0 为不限购"
    )
    deleted = models.IntegerField(verbose_name="是否删除", null=False, default=0)


class Promotion(models.Model):
    class Meta:
        verbose_name = "促销活动"
        db_table = "promotion"
        app_label = "poseidon"

    objects = models.Manager().db_manager(using=settings.POSEIDON_DB_NAME)
    id = models.AutoField(verbose_name="主键", primary_key=True, db_column="id")
    create_time = models.DateTimeField(
        verbose_name="创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name="更新时间", auto_now=True, db_column="update_time"
    )
    name = models.CharField(verbose_name="活动名称", null=False, max_length=256)
    status = models.IntegerField(
        verbose_name="状态",
        null=False,
        choices=PromotionStatus.choices,
        default=PromotionStatus.CREATING
    )
    start_sign_up_time = models.DateTimeField(
        verbose_name="提报开始时间", null=False
    )
    finish_sign_up_time = models.DateTimeField(
        verbose_name="提报结束时间", null=False
    )
    online_time = models.DateTimeField(verbose_name="促销开始时间", null=False)
    offline_time = models.DateTimeField(verbose_name="促销结束时间", null=False)
    description = models.TextField(verbose_name="活动描述")
    priority = models.IntegerField(
        verbose_name="优先级",
        null=False,
        choices=PromotionPriority.choices,
        default=PromotionPriority.LOW
    )


class UnitRelateService(models.Model):
    class Meta:
        app_label = 'poseidon'
        db_table = 'visual_unit_related_service'
        verbose_name = '美购列表组件关联美购'

    objects = models.Manager().db_manager(using=settings.POSEIDON_DB_NAME)
    id = models.AutoField(verbose_name="主键", primary_key=True, db_column="id")
    page_id = models.IntegerField(verbose_name='页面id')
    unit_id = models.IntegerField(verbose_name='组件id')
    related_type = models.IntegerField(
        verbose_name='组件关联美购方式',
        choices=VisualUnitRelatedServiceType,
        default=VisualUnitRelatedServiceType.SKU
    )
    related_id = models.IntegerField(verbose_name='关联id')
    create_time = models.DateTimeField(
        verbose_name="创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name="更新时间", auto_now=True, db_column="update_time"
    )
    commodity_id = models.IntegerField(verbose_name="SKU商品id", default=0)
    service_id = models.IntegerField(verbose_name="SPU商品id", null=False)
    is_online = models.BooleanField(verbose_name="是否上线", default=True)
    position = models.IntegerField(default=0, verbose_name=u'位置')


class PromotionRule(models.Model):
    class Meta:
        verbose_name = "促销活动规则映射表"
        db_table = "promotion_rule"
        app_label = "poseidon"

    objects = models.Manager().db_manager(using=settings.POSEIDON_DB_NAME)
    id = models.AutoField(verbose_name="主键", primary_key=True, db_column="id")
    create_time = models.DateTimeField(
        verbose_name="创建时间", auto_now_add=True, db_column="create_time"
    )
    update_time = models.DateTimeField(
        verbose_name="更新时间", auto_now=True, db_column="update_time"
    )
    promotion_id = models.IntegerField(verbose_name="促销活动id", null=False)
    composition_rule_type = models.CharField(
        verbose_name="促销活动类型名称", null=False, max_length=128, default=""
    )


class VisualPage(models.Model):
    class Meta:
        app_label = 'visual'

    visualgroup_id = models.IntegerField(verbose_name='分组id')
    visualspecial_id = models.IntegerField(verbose_name='专题id')
    name = models.CharField(max_length=100, verbose_name="页面名称")
    is_new = models.BooleanField(default=False, verbose_name="是否为新页面")


class Unit(models.Model):
    class Meta:
        verbose_name = "组件表"
        db_table = "visual_unit"
        app_label = "poseidon"

    unit_type = models.IntegerField(choices=UnitType, verbose_name="组件类型")
    visual_page = models.ForeignKey(VisualPage, verbose_name="关联可视化页面", on_delete=models.CASCADE)
    content = models.TextField(default="{}", verbose_name="组件内容")
    created_time = models.DateTimeField(auto_now_add=True, verbose_name="创建时间")
    modify_time = models.DateTimeField(auto_now=True, verbose_name="更新时间")


class UnitActivity(models.Model):
    class Meta:
        verbose_name = "组件和活动关联表"
        db_table = "visual_unitactivity"
        app_label = "poseidon"

    unit = models.ForeignKey(Unit, verbose_name="关联组件")
    promotion = models.ForeignKey(Promotion, verbose_name="关联活动")
