# -*- coding: utf-8 -*-

from rpc.cache import group_cache
from group.models import GroupFollow, Group, Topic, TopicFollow

from django.core.management import BaseCommand


group_follow_key = "group:follow:{group_id}"
topic_follow_key = "topic:follow:{topic_id}"


class Command(BaseCommand):

    def handle(self, *args, **options):

        for group in Group.objects.all():
            key = group_follow_key.format(group_id=group.id)
            group_cache.set(key, GroupFollow.objects.filter(group_id=group.id, is_online=True).count())

        for topic in Topic.objects.all():
            key = topic_follow_key.format(topic_id=topic.id)
            group_cache.set(key, TopicFollow.objects.filter(topic_id=topic.id, is_online=True).count())
