#!/usr/bin/env python
# -*- coding: utf-8 -*-

from group.models import TopContent


class TopContentService(object):

    @staticmethod
    def format_top_data(top_content):
        """
        格式化置顶数据
        :param top_content:
        :return:
        """
        return {
            "theme": top_content.theme,
            "title": top_content.title,
            "content_type": top_content.content_type,
            "content_id": top_content.content_id,
        }

    @classmethod
    def get_top_content_data(cls, related_type, related_id):
        """
        获取置顶数据
        :param related_type:
        :param related_id:
        :return:
        """
        _top_contents = TopContent.objects.filter(
            is_online=True,
            related_type=related_type,
            related_id=related_id
        )
        return list(map(cls.format_top_data, _top_contents))
