# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from api.models.audit import SimpleActionLog
from api.tool.datetime_tool import get_timestamp


def audit_write_log(user, package, action, object_type=None, object_id=None, message=None):
    SimpleActionLog.objects.create(
        user_id=user.id,
        package_new=package,
        action_new=action,
        object_type=object_type,
        object_id=object_id,
        message=message,
    )


def get_audit_log_data(audit_log):
    assert isinstance(audit_log, SimpleActionLog)
    return {
        'id': audit_log.id,
        'action_time': get_timestamp(audit_log.action_time),
        'user_id': audit_log.user_id,
        'package': audit_log.package,
        'object_type': audit_log.object_type,
        'object_id': audit_log.object_id,
        'action': audit_log.action,
        'message': audit_log.message,
    }
