# coding=utf-8
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import LiveWhiteList
from api.tool.live_tool import get_or_create_channel_by_user_id


class Command(BaseCommand):
    """
    python manage.py insert_20170328_create_livechannel
    """

    def handle(self, *args, **options):
        lists = LiveWhiteList.objects.filter(user__person__livechannel__isnull=True)
        for list in lists:
            try:
                chanel = get_or_create_channel_by_user_id(list.user_id)
                print list.user_id, chanel.id
            except Exception as e:
                print list.user_id, e.message
        print u'Done!'
