# coding=utf-8

from datetime import datetime
from django.core.management import BaseCommand
from django.db.models import Q

from api.models import Service
from rpc.tool.queryset_tool import big_qs_iter


class Command(BaseCommand):
    """
    python manage.py update_20190403_service_tip
    """

    def handle(self, *args, **options):
        services = Service.objects.using('slave').all()
        for service in big_qs_iter(services):
            print(service.tip)
            service.tip = ''
            service.save()
        print 'DONE!'


