# -*- coding:utf-8 -*-
from django.db import models
from django.contrib.auth.models import User
from django.conf import settings


class BDTransferAutoAssignor(models.Model):

    class Meta:
        db_table = 'hera_bdtransfer_auto_assignor'
        app_label = 'hera'
        verbose_name = '自动分配顾问表'

    user = models.ForeignKey(User, verbose_name=u'用户id', related_name='auto_assignor')
    ding = models.CharField(verbose_name=u'钉钉账号', max_length=20, null=False)
    top = models.IntegerField(verbose_name=u'每日上限', default=80)
    low = models.IntegerField(verbose_name=u'每日下限', default=10)
    is_active = models.BooleanField(verbose_name=u'是否解封', default=True)
    is_f = models.BooleanField(verbose_name=u'是否强制', default=False)


class BDTransferAssignRecord(models.Model):

    class Meta:
        db_table = 'hera_bdtransfer_assign_record_copy1'
        app_label = 'hera'
        verbose_name = '转诊顾问每天分配记录表'

    user = models.ForeignKey(User, verbose_name=u'用户id', related_name='day_record_user')
    count = models.IntegerField(verbose_name=u'每天分配数量', default=0)
    date = models.DateField(verbose_name=u'分配日期', auto_now_add=True)


class ScheduleTime(models.Model):

    class Meta:
        db_table = 'hera_schedule_time'
        app_label = 'hera'
        verbose_name = '早晚班时间'

    morning_start = models.IntegerField(verbose_name=u'早班开始时间',default=10)
    morning_end = models.IntegerField(verbose_name=u'早班结束时间',default=19)
    night_start = models.IntegerField(verbose_name=u'晚班开始时间',default=14)
    night_end = models.IntegerField(verbose_name=u'晚班结束时间',default=23)


class TransferRate(models.Model):

    class Meta:
        db_table = 'al_community_hera_transfer_rate'
        app_label = 'hera'
        verbose_name = '转诊顾问转化质量标准表'

    objects = models.Manager().db_manager(using=settings.DOCTOR_TRAFFIC_DB)

    date = models.DateField(verbose_name=u'计算时间')
    consultant_id = models.CharField(verbose_name=u'顾问id', max_length=100)
    avg_30_inversion_rate = models.FloatField(verbose_name=u'转化标准x')
    avg_30_order_amount = models.FloatField(verbose_name=u'转化标准y')



class BDTransferUserSchedule(models.Model):

    class Meta:
        db_table = 'hera_transfer_user_schedule'
        app_label = 'hera'
        verbose_name = '转诊顾问排班表'

    user = models.ForeignKey(User, verbose_name=u'用户id', related_name='schedule_user')
    date = models.DateField(verbose_name=u'排班日期', null=False)
    morning = models.BooleanField(verbose_name=u'早班', default=False)
    night = models.BooleanField(verbose_name=u'晚班', default=False)
