# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.gaia import POPUP_CATEGORY
from api.models.greetpopup import GreetingPopup


class PopupDB(DataBuilder):
    def getval_jump_type(self, obj):
        if obj.topic_id:
            return u'话题'
        elif obj.diary_id:
            return u'日记本'
        elif obj.special:
            return u'美购专题'
        elif obj.service:
            return u'美购'
        elif obj.tag:
            return u'圈子'
        elif obj.activity_id:
            return u'免费活动'
        elif obj.url and obj.category and obj.category==POPUP_CATEGORY.CONSULT:
            return u'视频面诊'
        elif obj.url:
            return u'网址'
        elif obj.aggregation_id:
            return u'新专题聚合'
        elif obj.visualpage_id:
            return u'自定义专题'
        elif obj.sec_image or obj.sec_image_ipx:
            return u'播放图片'
        else:
            return ''


@DB
class PopupDQ(DataSQLQuery):
        model = GreetingPopup
        data_model = PopupDB

        def filter_start_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)

        def filter_end_time(self, srch_key, srch_val, regex=False):
            return self._qry_time_range(srch_key, srch_val, regex)
