#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/07/03 17:29:24
#   Desc    :   pos机终端
#
from django.db.models import Q

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery

from api.models import Order
from api.models.pos import POSMachine, POSRecord, POSSum
from api.models import ORDER_STATUS


@DB
class POSMachineDQ(DataSQLQuery):
    model = POSMachine
    data_model = DataBuilder


@DB
class POSRecordDQ(DataSQLQuery):
    model = POSRecord
    data_model = DataBuilder


class POSSumDB(DataBuilder):

    def getval_hospital_payment(self, item):
        orders = Order.objects.filter(
            service__doctor=item.doctor, status=ORDER_STATUS.USED,
            validate_time__year=item.day.year,
            validate_time__month=item.day.month,
            validate_time__day=item.day.day
        )
        return sum([x.hospital_payment for x in orders])


@DB
class POSSumDQ(DataSQLQuery):
    model = POSSum
    data_model = POSSumDB

    def filter_month(self, key, value, regex=False):
        year, month = value.split('-')
        return Q(day__year=year, day__month=month)
