# coding=utf-8
from gm_types.gaia import PLATFORM_CHANNEL

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from launch.models import QuestionnaireTheme, QuestionnaireQuestions


class QuestionnaireThemeDB(DataBuilder):
    """
    UpdatePop实体的返回数据格式
    """

    def getval_operator(self, obj, default=''):
        return obj.operator.last_name or obj.operator.username


@DB
class QuestionnaireThemeDQ(DataSQLQuery):
    """
    UpdatePop实体查询过滤
    """
    model = QuestionnaireTheme
    data_model = QuestionnaireThemeDB


class QuestionnaireQuestionsDB(DataBuilder):
    """
    问卷问题
    """
    pass


@DB
class QuestionnaireQuestionsDQ(DataSQLQuery):
    model = QuestionnaireQuestions
    data_model = QuestionnaireQuestionsDB
