# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_types.gaia import RANK_LIST_TYPE, TAG_TYPE
from api.models.ranklist import RankList, RankBoard, RankboardData, RankBoardBatch, RankBoardMap
from gm_dataquery.db import DB
from rpc.tool.dict_mixin import to_dict

class RankListDB(DataBuilder):
    def getval_rank_type(self, obj):
        return RANK_LIST_TYPE.getDesc(obj.rank_type)


@DB
class RankListDQ(DataSQLQuery):
    model = RankList
    data_model = RankListDB


class RankboardDB(DataBuilder):
    def getval_data_item_tags(self, obj):
        return list(obj.data_tags.filter(tag_type__in=[
            TAG_TYPE.BODY_PART, TAG_TYPE.BODY_PART_SUB_ITEM, TAG_TYPE.ITEM_WIKI
        ]).values_list('id', flat=True))

    def getval_data_city_tags(self, obj):
        return list(obj.data_tags.filter(tag_type=TAG_TYPE.CITY).values_list('id', flat=True))

@DB
class RankboardDQ(DataSQLQuery):
    model = RankBoard
    data_model = RankboardDB

@DB
class RankboarddataDQ(DataSQLQuery):
    model = RankboardData
    data_model = DataBuilder


class RankBoardBatchDB(DataBuilder):
    def getval_tags_name(self, obj):
        tags = obj.tags.all()
        return [x.name for x in tags]

    def getval_create_time(self, obj):
        return obj.create_time.strftime("%Y-%m-%d %H:%M:%S")


@DB
class RankBoardBatchDQ(DataSQLQuery):
    model = RankBoardBatch
    data_model = RankBoardBatchDB

    def create(self, **kwargs):
        tags = kwargs.pop('tags')
        obj = self.model.objects.create(**kwargs)
        obj.tags = tags
        return to_dict(obj)


class RankBoardMapDB(DataBuilder):
    def getval_create_time(self, obj):
        return obj.create_time.strftime("%Y-%m-%d %H:%M:%S")


@DB
class RankBoardMapDQ(DataSQLQuery):
    model = RankBoardMap
    data_model = RankBoardMapDB