# coding=utf-8
from api.models import SpecialItem
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB


class SpeciaServiceDB(DataBuilder):
    def getval_project_name(self, obj):
        return ''.join(obj.serviceitem.items_name)

    def getval_active_price(self, obj):
        price_info = obj.get_price_info()
        return price_info.get('gengmei_price', 0)

    def getval_pre_payment_price(self, obj):
        price_info = obj.get_price_info()
        return price_info.get('pre_payment_price', 0)

    def getval_discount(self, obj):
        price_info = obj.get_price_info()
        return price_info.get('discount', 0)

    def getval_sell_num_limit(self, obj):
        price_info = obj.get_price_info()

        if (not obj.special.is_seckill) and (obj.doctorseckillapply is None) and (not obj.special.groupbuy_id):
            return obj.serviceitem.sku_stock
        return price_info.get('sale_limit', 0)

    def getval_total_num_limit(self, obj):
        return obj.doctorseckillapply.left_stock

    def getval_serviceitem__gengmei_price(self, obj):
        price_info = obj.serviceitem.get_default_price_info()
        return price_info.get('gengmei_price', 0)

    def getval_tip(self, obj):
        return obj.tip


@DB
class SpecialServiceDQ(DataSQLQuery):
    model = SpecialItem
    data_model = SpeciaServiceDB
