# -*- coding: UTF-8 -*-

from gm_dataquery.db import DB
from gm_dataquery.dataquery import DataSQLQuery

from api.models.word import SynonymGroup, Word
from hera.utils import model_edit, commastr_to_list


@DB
class SynonymDQ(DataSQLQuery):
    model = SynonymGroup

    def filter_words_string(self, srch_key, srch_val, regex=False):
        if srch_val:
            self.distinct = True
        return self._default_q('words__text', srch_val, regex)

    def create(self, **kwargs):
        keyword = kwargs['keyword']
        synonym_group = SynonymGroup.objects.create()
        return {'id': synonym_group.id}

    def update(self, updates, **kwargs):
        gid = kwargs.get('id', '')
        delete_group = updates.pop('delete_group', False)
        synonym_group = SynonymGroup.objects.get(id=gid)
        if delete_group:
            # 删除操作
            synonym_group.delete()
            return {'id': gid}
        else:
            # synonym_str = updates.pop('synonyms_string', None)
            # updates['synonym_list'] = None
            # synonym_group.update_words([])
            return {'id': gid}
