# coding=utf-8
from gm_types.gaia import PLATFORM_CHANNEL

from api.models.updatepop import UpdatePop
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB


class UpdatePopDB(DataBuilder):
    """
    UpdatePop实体的返回数据格式
    """

    def getval_create_time(self, obj, default=''):
        if obj.create_time:
            return str(obj.create_time)[0:19]

    def getval_source(self, obj, default=''):
        if obj.source:
            if obj.source == PLATFORM_CHANNEL.IOS:
                return 'IOS'
            if obj.source == PLATFORM_CHANNEL.ANDROID:
                return 'ANDROID'


@DB
class UpdatePopDQ(DataSQLQuery):
    """
    UpdatePop实体查询过滤
    """
    model = UpdatePop
    data_model = UpdatePopDB

