# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import CouponInfo, BusinessChannel


class UserCouponDB(DataBuilder):
    def getval_coupon(self, obj):
        return obj.coupon.name if obj.coupon else ''

    def getval_channel(self, obj):
        channel = ''
        if obj.channel:
            channel = BusinessChannel.getDesc(obj.channel)
        elif obj.coupon_launch:
            channel = BusinessChannel.getDesc(obj.coupon_launch.channel) if obj.coupon_launch.channel is None else ''
        return channel

    def getval_gift_name(self, obj):
        return obj.coupon_gift.name if obj.coupon_gift else ''


@DB
class UserCouponDQ(DataSQLQuery):
        model = CouponInfo
        data_model = UserCouponDB
