# -*- coding: utf-8 -*-
from rpc.decorators import bind_context
from api.models.business.city_relation import BusinessCityRelation
from hippo.models.doctor import Doctor
from django.db.models import Q
from themis.models import Team
from gm_types.gaia import TEAM_TYPE

@bind_context('hera/business/doctor/list')
def business_doctor_list(ctx, options={},page_num=1,page_size=10):
    cur_user = ctx.session.user
    doctor_list = []
    # role_type = None
    # bdm_cm = BusinessCityRelation.objects.filter(username=str(cur_user.id)).first()

    # if bdm_cm:
    #     role_type = bdm_cm.role_type

    business_partener_list = [cur_user]

    # if role_type is not None:
    #     group_str = bdm_cm.group
    sub_team_list = []
    cur_user_team_set = Team.objects.filter(team_type=TEAM_TYPE.BUSINESS, team_user=cur_user)
    for single_team in cur_user_team_set:
        sub_team_list.extend(single_team.all_children_team)

    for sub_single_team in sub_team_list:
        business_partener_list.extend(sub_single_team.team_user.all())

    q = Q(business_partener__in=business_partener_list)
    if options.get('query',{}):
        if options.get('query').get('doctor_type'):
            q &= Q(doctor_type=options.get('query').get('doctor_type'))
        if options.get('query').get('is_online'):
            q &= Q(is_online=bool(int(options.get('query').get('is_online'))))
    if options.get('filter',{}):
        field = options.get('filter').get('field')
        value = options.get('filter').get('value')
        if field and value:
            if field == 'doctor_name':
                q &= Q(name__regex=value)
            elif field == 'hospital_name':
                q &= Q(hospital__name__regex=value)
            elif field == 'business_partener_username':
                q &= Q(business_partener__username=value)
            elif field == 'hospital_city_name':
                q &= Q(hospital__city__name=value)
            elif field == 'login_phone':
                q &= Q(user__person__phone=value)
            elif field == 'doctor_phone':
                q &= Q(phone=value)

    doctor_set = Doctor.objects.filter(q)
    count = doctor_set.count()

    page_count = count//page_size
    if count % page_size > 0:
        page_count += 1
    if page_count == 0:
        page_count = 1
    if page_num<1:
        page_num = 1
    if page_num>page_count:
        page_num = page_count

    doctor_set = doctor_set[(page_num-1)*page_size:(page_num-1)*page_size+page_size]
    for single_doctor in doctor_set:
        doctor_dict = {
            'doctor_id':single_doctor.id,
            'doctor_name':single_doctor.name,
            'doctor_type':single_doctor.doctor_type,
            'is_online':"1" if single_doctor.is_online else "0",
            'business_partener_username':single_doctor.business_partener.username,
            'created_at':single_doctor.created_at.strftime('%Y-%m-%d %H:%M:%S') if single_doctor.created_at else ''
        }
        hospital_name = ''
        try:
            hospital_name = single_doctor.hospital.name
        except:
            pass

        d_merchant = ''
        try:
            d_merchant = single_doctor.d_merchant.name
        except:
            pass

        if hospital_name:
            doctor_dict['hospital_name'] = hospital_name
        elif d_merchant:
            doctor_dict['hospital_name'] = d_merchant
        else:
            doctor_dict['hospital_name'] = single_doctor.name

        if d_merchant:
            doctor_dict['d_merchant'] = d_merchant
        elif hospital_name:
            doctor_dict['d_merchant'] = hospital_name
        else:
            doctor_dict['d_merchant'] = single_doctor.name

        doctor_list.append(doctor_dict)

    return {
        'pageNum':page_num,
        'pageSize':page_size,
        'pageCount':page_count,
        'count':count,
        'doctor_list':doctor_list
    }





