# -*- coding: utf-8 -*-

from datetime import datetime
from django.db.models import Q
from django.conf import settings

from gm_types.gaia import INDEX_CARD_TYPE
from rpc.tool.error_code import CODES, gen

from rpc.decorators import bind_context
from rpc.tool.log_tool import logging_exception
from api.models import FeedOperateV2
from api.models import Doctor


location_map = {
    #1: [4, 1],
    #2: [4, 2],
    #3: [4, 3],
    #4: [8, 1],
    #5: [8, 2],
    #6: [8, 3],
    #8: [12, 2],
    #9: [12, 3],
    #10: [16, 1],
    #11: [16, 2],
    #12: [16, 3],
    #13: [20, 1],
    #14: [20, 2],
    #15: [20, 3],
    #16: [24, 1],
    #17: [24, 2],
    #18: [24, 3],
    19: [3, 1],
    20: [6, 1],
    21: [9, 1],
    22: [12, 1]
}


feed_operate = 'hera/feed_operate'

@bind_context(feed_operate + '/create')
def feed_operate_create(ctx, diary_ids, tractate_ids, location, doctor_id,
                        start_time, end_time, city_ids=[], tab_id=0,
                        service_type='2'):
    """首页精选运营位创建。

    如果创建失败则进行还原删除操作。
    @params: diary_ids: 日记ID列表
    @params: tractate_ids: 帖子ID列表
    @params: location: 插入位置信息
    @params: doctor_id: 下单医生信息
    @params: start_time: 开始时间(2019-08-29 10:10:11)
    @params: end_time: 结束时间(2019-08-29 10:10:11)
    @params: city_ids: 投放城市id列表
    @params: tab_id: 默认精选0
    @params: service_type: 默认广告2
    """

    if not diary_ids and not tractate_ids:
        return gen(CODES.PARAMS_INVALID)

    if not all([location, start_time, end_time, doctor_id, city_ids, service_type]):
        return gen(CODES.PARAMS_INVALID)

    location_info = location_map.get(location)
    if not location_info:
        return gen(CODES.PARAMS_INVALID)

    try:
        name = Doctor.objects.get(id=doctor_id).name
    except:
        return gen(CODES.DOCTOR_NOT_FOUND)

    common_params = {
        "location": "choice",
        "rank": location_info[0],
        "show_type": location_info[1],
        "start_time": datetime.strptime(start_time, "%Y-%m-%d %H:%M:%S"),
        "end_time": datetime.strptime(end_time, "%Y-%m-%d %H:%M:%S"),
        "tab_id": tab_id,
        "is_online": True,
        "service_type": service_type,
        "name": name,
    }

    feeds = []
    for diary_id in diary_ids:
        item = {
            "card_type": INDEX_CARD_TYPE.DIARY,
            "card_id": diary_id
        }
        feeds.append(item)

    for tractate_id in tractate_ids:
        item = {
            "card_type": INDEX_CARD_TYPE.TRACTATE,
            "card_id": tractate_id
        }
        feeds.append(item)

    # res = []
    err = {"diary_ids": [], "tractate_ids": []}
    for params in feeds:
        params.update(common_params)
        try:
            feed = FeedOperateV2.objects.create(**params)
            feed.cities = city_ids
        except:
            logging_exception()
            if params["card_type"] == INDEX_CARD_TYPE.TRACTATE:
                err["tractate_ids"].append(params["card_id"])
            elif params["card_type"] == INDEX_CARD_TYPE.DIARY:
                err["diary_ids"].append(params["card_id"])

    return err
