# -*- coding: utf-8 -*-
import json

from django.contrib.auth.models import User

from api.tool.user_tool import get_user_from_context
from launch.models.screen_label import ShortcutScreenLabel
from rpc.decorators import bind_context

screenlabel_pre = 'hera/screenlabel'

@bind_context(screenlabel_pre + '/delete')
def screenlabel_delete(ctx, screenlabel_id):
    """
    根据ID删除一个specialitem
    """
    user = get_user_from_context(ctx)
    screenlabel = ShortcutScreenLabel.objects.get(pk=screenlabel_id)
    screenlabel.is_delete = True
    screenlabel.operator_id = user.id
    screenlabel.save()
    return {'id': screenlabel_id}
