# -*- coding: UTF-8 -*-
from api.models import SeckillPolymer
from rpc.decorators import bind_context
from hera.queries.choice_query import choice_query
from gm_types.gaia import POLYMER_TYPE

uri_pre = 'hera/seckillpolymer'


@bind_context(uri_pre + '/choices')
def polymer_choices(ctx, q='', page=1, num=30, initial=None):
    page = int(page)
    num = int(num)

    query = choice_query(SeckillPolymer, ['id', 'title'], 'id', q, initial)

    # NOTICE: 暂时只返回 新专题聚合
    query = query.filter(polymer_type=POLYMER_TYPE.SPECIAL_POLYMER)

    # total_count = query.count()
    total_count = 0
    start_pos = (page - 1) * num
    start_pos = start_pos if start_pos >= 0 else 0
    results = [
        {
            'id': obj.id,
            'text': u'{}: {}'.format(
                obj.id, obj.title,
            ),
        } for obj in query[start_pos: start_pos + num]]
    return {'total_count': total_count, 'results': results, 'page': page, 'num': num}
