# coding=utf-8
# from _mysql_exceptions import IntegrityError
import datetime
import json

from django.db import transaction, IntegrityError

from api.models import UpdatePop
from api.tool.user_tool import get_user_from_context
from hera.queries.updatepop import UpdatePopDQ
from rpc.decorators import bind_context
from rpc.tool.dict_mixin import to_dict

uri_pre = 'hera/updatepop'


@bind_context(uri_pre + '/query')
def updatepop_query(ctx, options):
    dqobj = UpdatePopDQ()
    return dqobj.process(**options)


@bind_context(uri_pre + '/getcount')
def get_updatepop_gount(ctx, source, version):
    """
    获取分享文案配置
    """
    if source is None or version is None:
        return None
    updatepop_count = UpdatePop.objects.filter(source=source, version=version).count()
    return updatepop_count


@bind_context(uri_pre + '/create')
def create_updatepop(ctx, updatepop_info=None):
    """
    新增客户端更新弹窗提示
    """
    if updatepop_info is None:
        return None
    updatepop = UpdatePop.objects.create(**updatepop_info)
    return {"content_id": updatepop.id}

