#coding=utf-8
import datetime
import re
from django.core.management import BaseCommand
from openpyxl import load_workbook
from api.models import Hospital_Extra


class Command(BaseCommand):
    """
    广审时间
    python manage.py ad_check_time
    """
    def handle(self, *args, **options):
        workbook = load_workbook('./ad_check_time.xlsx', read_only=True, data_only=True)
        now_time = datetime.datetime.now()
        for item in workbook['time_check']:
            hospital_id = item[0].value
            date_info = None
            print(hospital_id)
            time = item[3].value
            if time:
                date_info = re.match("\d+/\d+/\d+", str(time)) or re.match("\d+-\d+-\d+", str(time)) or re.match("\d+\.\d+\.\d+", str(time))
            if date_info:
                time = date_info.group(0).replace(".", "-").replace("/", "-")
            else:
                time = None
            try:
                obj = Hospital_Extra.objects.filter(hospital_id=hospital_id).last()
                if obj and not time:
                    obj.ad_check_end_time = now_time
                    obj.save()
                elif obj and time:
                    obj.ad_check_end_time = time
                    obj.save()
            except:
                pass


