# coding=utf-8
# create by oldman at 2017/11/13
import redis
from django.db import models
from django.db.models import QuerySet
from django.conf import settings
from gm_types.doctor import PV_TYPE
from gm_types.gaia import PULL_BLACK_TYPE
from hippo.models.hospital import Hospital



class Advertise_pv_stats(models.Model):
    """医生页面浏览记录"""

    class Meta:
        app_label = 'hippo'
        db_table = 'hippo_advertise_pv_static'

    class Advertise_pv_staticManager(models.Manager):
        """!!!这个表没有在zhengxing库里"""

        def get_queryset(self):
            qs = QuerySet(self.model).using(settings.DOCTOR_TRAFFIC_DB)
            return qs

    objects = models.Manager().db_manager(using=settings.DOCTOR_TRAFFIC_DB)

    stat_date = models.DateField(verbose_name=u'统计时间')
    time_str = models.DateTimeField(verbose_name=u'浏览时间', null=True)
    pv_type = models.IntegerField(verbose_name=u'页面类型', choices=PV_TYPE, null=True)
    page_name = models.CharField(verbose_name=u'页面名称', max_length=100, null=True)
    related_id = models.CharField(verbose_name=u'关联的id', null=True, max_length=100)
    city_id = models.CharField(verbose_name=u'城市ID', max_length=50, null=True)
    city_name = models.CharField(verbose_name=u'城市名字', max_length=50, null=True)
    province_id = models.CharField(verbose_name=u'省份ID', max_length=50, null=True)
    province_name = models.CharField(verbose_name=u'省份名字', max_length=50, null=True)
    doctor_id = models.CharField(verbose_name=u'医生ID', max_length=100)
    merchant_id = models.BigIntegerField(verbose_name=u'商户ID')
    user_id = models.CharField(verbose_name=u'用户ID', max_length=50, null=True)
    user_name = models.CharField(verbose_name=u'用户昵称', max_length=50, null=True)
    birthday = models.DateField(verbose_name=u'用户生日', null=True)
    user_rights_level = models.CharField(verbose_name=u'用户等级', max_length=20, null=True)
    membership_level = models.CharField(verbose_name=u'用户等级', max_length=20, null=True)
    tag = models.TextField(verbose_name=u'用户标签', null=True)
    cl_id = models.CharField(verbose_name=u'设备id', null=True, max_length=50)
    cl_type = models.CharField(verbose_name=u'设备类型', null=True, max_length=50)
    channel = models.CharField(verbose_name=u'渠道', max_length=100)


class Advertise_conver_stats(models.Model):
    """
    医生新私信记录
    """

    class Meta:
        app_label = 'hippo'
        db_table = 'hippo_advertise_conver_stats'

    stat_date = models.DateField(verbose_name=u'统计时间')
    time_str = models.DateTimeField(verbose_name=u'发私信时间', null=True)
    conversation_id = models.CharField(verbose_name=u'私信ID', null=True, max_length=50)
    city_id = models.CharField(verbose_name=u'城市ID', max_length=50, null=True)
    city_name = models.CharField(verbose_name=u'城市名字', max_length=50, null=True)
    province_id = models.CharField(verbose_name=u'省份ID', max_length=50, null=True)
    province_name = models.CharField(verbose_name=u'省份名字', max_length=50, null=True)
    doctor_id = models.CharField(verbose_name=u'医生ID', max_length=100)
    merchant_id = models.BigIntegerField(verbose_name=u'商户ID')
    doctor_user_id = models.CharField(verbose_name=u'医生的user_id', max_length=50, null=True)
    user_id = models.CharField(verbose_name=u'用户ID', max_length=50, null=True)
    user_name = models.CharField(verbose_name=u'用户昵称', max_length=50, null=True)
    birthday = models.DateField(verbose_name=u'用户生日', null=True)
    user_rights_level = models.CharField(verbose_name=u'用户等级', max_length=20, null=True)
    membership_level = models.CharField(verbose_name=u'用户等级', max_length=20, null=True)
    tag = models.TextField(verbose_name=u'用户标签', null=True)
    message_id = models.IntegerField(verbose_name=u'这条私信的私信ID(message)', null=False)


class AdWhiteList(models.Model):
    """
    广告账户扣费白名单，在此名单内的商户才会扣费
    """

    class Meta:
        app_label = 'hippo'
        db_table = 'hippo_ad_whitelist'

    doctor_id = models.CharField(verbose_name=u'医生ID', max_length=100)
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u'进入白名单时间')


class PvOverNorm(models.Model):
    """
    上月pv超过3000的商户名单
    """

    class Meta:
        app_label = 'hippo'
        db_table = 'hippo_pvovernorm'

    doctor_id = models.CharField(verbose_name=u'医生ID', max_length=100)
    pv_total = models.IntegerField(verbose_name=u'上月pv量')
    # 若2018.01 pv超过3000，则cal_month存201802
    cal_month = models.IntegerField(verbose_name=u'计费月份')

class IpBlackList(models.Model):
    class Meta:
        app_label = "hippo"
        verbose_name = "IP黑名单记录"

    ip = models.CharField(db_index=True, max_length=255, verbose_name="ip地址")
    pull_black_type = models.IntegerField(choices=PULL_BLACK_TYPE, verbose_name="拉黑类型")
    create_at = models.DateTimeField(db_index=True, auto_now_add=True, verbose_name="创建时间")
    update_at = models.DateTimeField(db_index=True, auto_now=True, verbose_name="更新时间")
    is_redis = models.BooleanField(default=False, verbose_name="是否写入redis")


class DeviceBlackList(models.Model):
    class Meta:
        app_label = "hippo"
        verbose_name = "设备黑名单记录"

    device_id = models.CharField(db_index=True, max_length=255, verbose_name="设备id")
    pull_black_type = models.IntegerField(choices=PULL_BLACK_TYPE, verbose_name="拉黑类型")
    create_at = models.DateTimeField(db_index=True, auto_now_add=True, verbose_name="创建时间")
    update_at = models.DateTimeField(db_index=True, auto_now=True, verbose_name="更新时间")
    is_redis = models.BooleanField(default=False, verbose_name="是否写入redis")


class CustomAdTeam(models.Model):
    class Meta:
        app_label = "hippo"
        verbose_name = "自定义广告关联商务"

    custom_ad_id = models.IntegerField(verbose_name="自定义广告ID")
    business_group = models.IntegerField(verbose_name='组织架构的组织', null=True)


class CustomAdHospital(models.Model):
    class Meta:
        app_label = "hippo"
        verbose_name = "自定义广告关联机构"

    custom_ad_id = models.IntegerField(verbose_name="自定义广告ID")
    hospital = models.ForeignKey(Hospital, related_name="custom_ad_hospital", verbose_name=u"医院")


black_name_pool=None
try:
    black_name_pool = redis.ConnectionPool(**settings.REDIS['black_name'])
except Exception as e:
    print(e)

class RedisClient(object):
    prefix = ""
    pool = None

    def __init__(self):
        self.client = redis.Redis(connection_pool=self.pool)

    def get_key(self, key):
        return self.prefix+key

    def set_key(self, key, value):
        key = self.get_key(key)
        self.client.set(key, value)

    def del_key(self, key):
        key = self.get_key(key)
        self.client.delete(key)

class IpBlackClient(RedisClient):
    prefix = settings.REDIS_BLACK_IP_PREFIX
    pool = black_name_pool

class DeviceBlackClient(RedisClient):
    prefix = settings.REDIS_BLACK_DEVICE_PREFIX 
    pool = black_name_pool

