# -*- coding: utf-8 -*-
# @Time    : 2019/9/4 3:12 PM
# @Author  : Esse
# @FileName: quick_reply.py

from django.db import models
from .doctor import Doctor


class QuickReplyGroup(models.Model):
    class Meta:
        verbose_name = u'医生私信快捷回复分组'
        db_table = 'hippo_quickreplygroup'
        app_label = 'hippo'

    doctor = models.ForeignKey(Doctor, verbose_name=u'对应医生')
    name = models.CharField(verbose_name=u'分组名称', max_length=100)
    rank = models.IntegerField(verbose_name=u'排序')
    created_time = models.DateTimeField(verbose_name=u'添加时间', auto_now_add=True)
    modify_time = models.DateTimeField(verbose_name=u'最后更新时间', auto_now=True)

    def update_rank(self, is_up):
        # 上移
        if is_up:
            up_group = QuickReplyGroup.objects.filter(doctor_id=self.doctor_id, rank=self.rank-1)
            if up_group.exists():
                up_group = up_group.first()
                base_rank = self.rank
                self.rank = base_rank - 1
                up_group.rank = base_rank
                self.save()
                up_group.save()
            else:
                pass
        # 下移
        else:
            down_group = QuickReplyGroup.objects.filter(doctor_id=self.doctor_id, rank=self.rank+1)
            if down_group.exists():
                down_group = down_group.first()
                base_rank = self.rank
                self.rank = base_rank + 1
                down_group.rank = base_rank
                self.save()
                down_group.save()
            else:
                pass


class QucikReplyContent(models.Model):
    class Meta:
        verbose_name = u'医生私信快捷回复内容'
        db_table = 'hippo_quickreplycontent'
        app_label = 'hippo'

    quickreplygroup = models.ForeignKey(QuickReplyGroup, verbose_name=u'关联的分组', related_name="qucik_reply_contents")
    name = models.CharField(verbose_name=u'分组名称', max_length=300)
    rank = models.IntegerField(verbose_name=u'排序')
    created_time = models.DateTimeField(verbose_name=u'添加时间', auto_now_add=True)
    modify_time = models.DateTimeField(verbose_name=u'最后更新时间', auto_now=True)

    def update_rank(self, is_up):
        # 上移
        if is_up:
            up_group = QucikReplyContent.objects.filter(quickreplygroup_id=self.quickreplygroup_id, rank=self.rank-1)
            if up_group.exists():
                up_group = up_group.first()
                base_rank = self.rank
                self.rank = base_rank - 1
                up_group.rank = base_rank
                self.save()
                up_group.save()
            else:
                pass
        # 下移
        else:
            down_group = QucikReplyContent.objects.filter(quickreplygroup_id=self.quickreplygroup_id, rank=self.rank+1)
            if down_group.exists():
                down_group = down_group.first()
                base_rank = self.rank
                self.rank = base_rank + 1
                down_group.rank = base_rank
                self.save()
                down_group.save()
            else:
                pass