# coding=utf-8
from __future__ import unicode_literals
import traceback

from rpc.decorators import bind

from api.models import SettlementItem
from api.models.distribute import DistributeRecord
from rpc.tool.log_tool import info_logger,exception_logger


@bind('api/create/distribute/data')
def get_doctor_id_merchant_level(distribute_data, settlement_id):
    distribute_type = distribute_data.get('distribute_type')
    distribute_id = distribute_data.get('distribute_id')
    try:
        settlements = SettlementItem.objects.filter(settlement=settlement_id).all()
        for settlement in settlements:
            DistributeRecord.objects.create(
                order_id=settlement.order_id,
                distribute_id=distribute_id,
                distribute_type=distribute_type,
            )
            info_logger.info(
                'api/create/distribute/data---create distribute_data--success!! distribute_type: {}, distribute_id: {}, settlement_id: {}, order_id:{}'.format(
                    distribute_type,
                    distribute_id,
                    settlement_id,
                    settlement.order_id
                ))
    except:
        exception_logger.error('api/create/distribute/data----create distribute_data fail error_data: {}, distribute_type: {}, distribute_id: {}, settlement_id: {}'.format(
            traceback.format_exc(),
            distribute_type,
            distribute_id,
            settlement_id,
        ))
    return None
