# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Award',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=64, verbose_name='\u5956\u9879\u540d\u79f0')),
                ('image', models.CharField(max_length=128, verbose_name='\u56fe\u7247')),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('update_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Lasker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('year', models.PositiveSmallIntegerField(unique=True, verbose_name='\u5e74\u5ea6')),
                ('name', models.CharField(max_length=64, verbose_name='\u5956\u9879\u540d\u79f0')),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('update_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('doctor_id', models.CharField(max_length=64)),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('award', models.ForeignKey(verbose_name=b'', to='lasker.Award')),
            ],
        ),
        migrations.CreateModel(
            name='Vote',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('wx_uid', models.CharField(max_length=64)),
                ('forged', models.BooleanField(default=False, verbose_name='\u865a\u5047\u6295\u7968')),
                ('create_at', models.DateTimeField(auto_now_add=True)),
                ('participant', models.ForeignKey(related_name='votes', verbose_name=b'', to='lasker.Participant')),
            ],
        ),
        migrations.AddField(
            model_name='award',
            name='lasker',
            field=models.ForeignKey(verbose_name='\u5e74\u5ea6\u5956', to='lasker.Lasker'),
        ),
        migrations.AlterUniqueTogether(
            name='participant',
            unique_together=set([('doctor_id', 'award')]),
        ),
        migrations.AlterUniqueTogether(
            name='award',
            unique_together=set([('lasker', 'name')]),
        ),
    ]
