#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management.base import BaseCommand

from launch.models import (
    QuestionnaireQuestion,
    QuestionnaireQuestions,
    QuestionnaireThemeAndQuestionRelations,
)


class Command(BaseCommand):
    """
    问题相关数据同步
    """
    def handle(self, *args, **kwargs):

        print("begin")

        fields = [
            # "id",
            # "questionnaire_theme_id",
            "title",
            "problem_type",
            "relation_question_id",
            # "rank",
            "is_effect",
            "is_delete",
            "is_influence_user_portrait",
            "create_time",
            "update_time",
        ]

        old_info = QuestionnaireQuestion.objects.all().iterator()
        # old_info = QuestionnaireQuestion.objects.filter(pk__in=[1, 5, 9])
        for item in old_info:
            _item_data = {field: getattr(item, field) for field in fields}

            obj_, status = QuestionnaireQuestions.objects.update_or_create(
                id=item.id,
                defaults=_item_data,
            )

            obj, state = QuestionnaireThemeAndQuestionRelations.objects.update_or_create(
                questionnaire_theme_id=item.questionnaire_theme_id,
                questionnaire_question_id=obj_.id,
                defaults={"rank": item.rank}
            )

        print("end")
