# coding:utf-8
import json
from django.core.management.base import BaseCommand

from mark.models import MarkFortuneConfigs
from utils.execel import ExcelReader


class Command(BaseCommand):
    """
    打卡活动配置导入 python manage.py mark_conf_insert
    """

    def handle(self, *args, **options):
        print('START')
        excel = ExcelReader('/tmp/打卡.xlsx')
        mark_config_objects = []
        sheet = excel._excel._sheets[2]
        for row in range(2, sheet.max_row):
            data = excel.read_row(row)
            if not data:
                continue
            constellation_enum = data[1]
            skin_trait_id = data[3]
            notes = json.dumps([data[4], data[5], data[6], data[7], data[8], data[9]])
            fitting_and_dread = {
                'fitting': [],
                'dread': [],
            }
            fitting_and_dread['fitting'].extend([
                {
                    'content': data[10],
                    'icon': data[11],
                },
                {
                    'content': data[12],
                    'icon': data[13],
                },
            ])
            fitting_and_dread['dread'].extend([
                {
                    'content': data[14],
                    'icon': data[15],
                },
                {
                    'content': data[16],
                    'icon': data[17],
                },
            ])
            mark_config_objects.append(
                MarkFortuneConfigs(
                    mark_activity_id=1,
                    skin_trait_id=skin_trait_id,
                    title='开心吗',
                    constellation=constellation_enum,
                    notes=notes,
                    fitting_and_dread=json.dumps(fitting_and_dread),
                )
            )
        MarkFortuneConfigs.objects.bulk_create(mark_config_objects)
        print('DONE')
