#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from django.utils import timezone

from gm_types.gaia import BLOOD_TYPE, MARK_ACTIVITY_TYPE
from gm_types.user_hierarchy import CONSTELLATION


class BaseModel(models.Model):
    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class MarkActivity(BaseModel):
    class Meta:
        verbose_name = u'打卡活动'
        db_table = 'api_mark_activity'

    solid_title = models.CharField(verbose_name=u'海报大标题(实心文案)', max_length=512, default="")
    hollow_title = models.CharField(verbose_name=u'海报大标题(空心文案)', max_length=512, default="")
    mark_type = models.CharField(u'打卡类型', choices=MARK_ACTIVITY_TYPE, default=MARK_ACTIVITY_TYPE.AI, max_length=2)
    remind_desc = models.CharField(u'提示文案', default='', max_length=256)


class MarkActivityTag(models.Model):
    class Meta:
        verbose_name = u'打卡活动关联标签1.0'
        db_table = 'api_mark_activity_rel_tag'

    mark_activity_id = models.IntegerField(verbose_name=u"关联打卡活动ID", db_index=True)
    tag_id = models.IntegerField(verbose_name=u"关联标签(1.0)ID", db_index=True)


class MarkFortuneConfigs(BaseModel):
    class Meta:
        verbose_name = u'打卡活动运势配置'
        db_table = 'api_mark_fortune_configs'

    mark_activity_id = models.IntegerField(verbose_name=u"关联打卡活动ID", db_index=True)
    skin_trait_id = models.IntegerField(verbose_name=u"肤质特征(关联SkinAge表索引ID)", db_index=True)
    title = models.CharField(verbose_name=u'文案标题(海报小标题)', max_length=512, default="")
    constellation = models.CharField(verbose_name=u"星座", max_length=12, choices=CONSTELLATION)
    blood_type = models.CharField(verbose_name=u"血型", max_length=12, choices=BLOOD_TYPE, default=BLOOD_TYPE.NONE)
    notes = models.TextField(verbose_name=u"注意事项 jsonstring", default="")  # eg: '["注意事项1", "注意事项2"]'
    fitting_and_dread = models.TextField(verbose_name=u'宜忌 jsonstring', default="")
    # eg: {"fitting": [{"content": "宜文案", "icon": "宜ICON"}, ], "dread": [{"content": "忌文案", "icon": "忌ICON"}, ]}
    # 内部索引位 == 顺序
