# -*- coding: utf-8 -*-
from django.db import models


class DeviceMiddleId(models.Model):
    class Meta:
        verbose_name = '记录遍历到device表的哪个id'
        db_table = 'mark_device_middle_id'

    middle_id = models.IntegerField(verbose_name=u'最后id')
    update_time = models.DateTimeField(auto_now=True)


class MarkGrayDevice(models.Model):
    class Meta:
        verbose_name = '灰度和版本号符合要求的灰度设备'
        db_table = 'mark_gray_device'

    t_device_id = models.IntegerField(verbose_name=u'device表id')


class MarkMiddleDevice(models.Model):
    class Meta:
        verbose_name = '灰度符合要求,低版本的灰度设备'
        db_table = 'mark_middle_device'

    t_device_id = models.IntegerField(verbose_name=u'device表id', db_index=True)


class MarkPushLog(models.Model):
    class Meta:
        verbose_name = '打卡push状态'
        db_table = 'mark_push_log'

    user_id = models.IntegerField(verbose_name=u'用户id', db_index=True)
    is_effective = models.BooleanField(verbose_name=u'是否能发通知', default=True)
    continuous_push_num = models.IntegerField(verbose_name=u'连续发送次数', default=0)
    reset_num = models.IntegerField(verbose_name=u'连续发送次数清零的次数', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
