# # coding: utf-8
# from api.models import ConversationTags, ConversationUserStatus, Conversation, message_signals, get_user_by_id
# from rpc.decorators import bind
# from rpc.exceptions import RPCNotFoundException, RPCPermissionDeniedException
# from gm_types.error import ERROR
#
# from rpc.tool.error_code import gen
#
#
# @bind('message/conversation/tags/add')
# def conversation_type_tags_add(user_id, name, comment=None):
#     instance = ConversationTags.add_tag(user_id=user_id, name=name, comment=comment)
#     return instance.to_dict()
#
# @bind('message/conversation/tags/update')
# def conversation_type_tags_update(id, name=None, comment=None, is_online=None):
#     ct = ConversationTags.objects.filter(id=id).first()
#     if not ct:
#         gen(ERROR.MESSAGE_CONVERSATION_TAG_NOT_EXIST)
#     ct = ct.modify(name=name, comment=comment, is_online=is_online)
#     return ct.to_dict()
#
# @bind('message/conversation/tags/list')
# def conversation_type_tags_list(user_id, page=1, size=10, is_slice=True):
#     cts = ConversationTags.objects.filter(user_id=user_id).prefetch_related('user_status_set')
#     if is_slice:
#         offset = (page - 1) * size
#         cts = cts[offset: offset + size]
#     return [ct.to_dict(with_bind_count=True) for ct in cts]
#
# @bind('message/conversation/tags/change_rank')
# def conversation_type_tags_change_rank(tag_ids):
#     cts = ConversationTags.change_rank(tag_ids)
#     return [tag.to_dict() for tag in cts]
#
# @bind('message/get_conversation_type_tags_by_ids')
# def get_conversation_type_tags_by_ids(ids):
#     cts = ConversationTags.objects.filter(id__in=ids)
#     return [ct.to_dict() for ct in cts]
#
# @bind('message/update_conversation_tags_by_conversation_id')
# def update_conversation_tags_by_conversation_id(conversation_id, user_id, tag_ids):
#     user = get_user_by_id(user_id)
#     if not user:
#         gen(ERROR.USER_NOT_FOUND)
#     c = Conversation.objects.filter(id=conversation_id).first()
#     if not c:
#         gen(ERROR.MESSAGE_INVALID_CONVERSATION)
#     cus = c.user_status_set.filter(user_id=user_id).first()
#     if not cus:
#         gen(ERROR.MESSAGE_NO_PERMISSION)
#     tags = cus.update_tags(tag_ids)
#     message_signals.post_touch_conversation(user=user, conversation=c)
#     return [tag.to_dict() for tag in tags]
#
# @bind('message/get_conversation_tags_by_conversation_id')
# def get_conversation_tags_by_conversation_id(conversation_id, user_id):
#     c = Conversation.objects.filter(id=conversation_id).first()
#     if not c:
#         gen(ERROR.MESSAGE_INVALID_CONVERSATION)
#     cus = c.user_status_set.filter(user_id=user_id).first()
#     if not cus:
#         gen(ERROR.MESSAGE_NO_PERMISSION)
#     return [ct.to_dict() for ct in cus.tags.all()]
