# coding:utf-8
from gm_types.gaia import SERVICE_TYPE, DIARY_CONTENT_LEVEL, REPORT_TYPE

from .event import *
from mimas.tasks import send_event_task


class EventDispatcher(object):
    @classmethod
    def process_event(cls, event):
        return event.emit()

    @classmethod
    def sent_create_portrait_signal(cls, user_id):
        event = AddPortraitEvent(user_id)
        return cls.process_event(event)

    @classmethod
    def sent_bind_phone_signal(cls, user_id):
        event = BindPhoneEvent(user_id)
        return cls.process_event(event)

    @classmethod
    def sent_topic_create_signal(cls, topic_id, user_id, topic_type=SERVICE_TYPE.NO_OPERATION):
        # 发布日记帖
        if topic_type == SERVICE_TYPE.OPERATION:
            event = CreateOperationTopicEvent(user_id, topic_id)
        elif topic_type == SERVICE_TYPE.NO_OPERATION:
            event = CreateNoneOperationTopicEvent(user_id, topic_id)

        return cls.process_event(event)

    @classmethod
    def sent_topic_commented_signal(cls, user_id, topic_id, author_id):
        # 评论日记贴　
        if user_id == author_id:
            return
        # 日记贴被评论暂时不加分
        # commented_event = TopicCommentedEvent(author_id, topic_id)
        # cls.process_event(commented_event)

        comment_event = CommentTopicEvent(user_id, topic_id)
        return cls.process_event(comment_event)

    @classmethod
    def sent_comment_diary_signal(cls, user_id, diary_id, author_id):
        # 评论日记本

        # 日记本被评论暂时不做
        # commented_event = DiaryCommentedEvent(author_id, diary_id)
        # cls.process_event(commented_event)
        commented_event = CommentDiaryEvent(author_id, diary_id)
        return cls.process_event(commented_event)

    @classmethod
    def sent_diary_content_level_change_signal(cls, user_id, diary_id, author_id, service_type, pre_level, now_level):
        if user_id == author_id:
            return

        if now_level == pre_level:
            return

        event = None

        if service_type == SERVICE_TYPE.NO_OPERATION and now_level == DIARY_CONTENT_LEVEL.EXCELLENT:
            if pre_level == DIARY_CONTENT_LEVEL.FINE:
                event = NonOpDiaryBeExFromFine(user_id=author_id, item_id=diary_id)
            else:
                event = NonOpDiaryBeExFromOther(user_id=author_id, item_id=diary_id)
        elif service_type == SERVICE_TYPE.NO_OPERATION and now_level == DIARY_CONTENT_LEVEL.FINE:
            if pre_level == DIARY_CONTENT_LEVEL.EXCELLENT:
                event = NonOpDiaryBeFineFromEx(user_id=author_id, item_id=diary_id)
            else:
                event = NonOpDiaryBeFineFromOther(user_id=author_id, item_id=diary_id)
        elif service_type == SERVICE_TYPE.OPERATION and now_level == DIARY_CONTENT_LEVEL.EXCELLENT:
            if pre_level == DIARY_CONTENT_LEVEL.FINE:
                event = OpDiaryBeExFromFine(user_id=author_id, item_id=diary_id)
            else:
                event = OpDiaryBeExFromOther(user_id=author_id, item_id=diary_id)
        elif service_type == SERVICE_TYPE.OPERATION and now_level == DIARY_CONTENT_LEVEL.FINE:
            if pre_level == DIARY_CONTENT_LEVEL.EXCELLENT:
                event = OpDiaryBeFineFromEx(user_id=author_id, item_id=diary_id)
            else:
                event = OpDiaryBeFineFromOther(user_id=author_id, item_id=diary_id)

        if now_level == DIARY_CONTENT_LEVEL.EXCELLENT:
            # 日记被标为优秀，
            event = None
            send_event_task(user_id=author_id, event_type=EventType.DIARY_TOBE_EXCELLENT)

        if not event:
            return

        return cls.process_event(event)

    @classmethod
    def sent_answer_be_recommended_signal(cls, user_id, answer_id, author_id):
        if answer_id == user_id:
            return

        event = AnswerBeRecommendedEvent(author_id, answer_id)
        return cls.process_event(event)

    @classmethod
    def sent_question_be_recommended_signal(cls, user_id, question_id, author_id):
        if user_id == author_id:
            return

        event = QuestionBeRecommendEvent(author_id, question_id)
        return cls.process_event(event)

    @classmethod
    def sent_item_is_spam_signal(cls, user_id, item_id, author_id, reply_type):
        if reply_type == REPORT_TYPE.TOPIC:
            event = TopicIsSpamEvent(author_id, item_id)
        elif reply_type in [REPORT_TYPE.REPLY, REPORT_TYPE.DIARY_REPLY]:
            event = CommentIsSpamEvent(item_id, author_id)

        return cls.process_event(event)

    @classmethod
    def sent_buy_service_signal(cls, user_id, service_id, pre_payment):
        event = BuyServiceEvent(user_id=user_id, item_id=service_id, pre_payment=pre_payment)
        return cls.process_event(event)

    @classmethod
    def sent_check_in_signal(cls, user_id):
        event = CheckinEvent(user_id)
        return cls.process_event(event)

