# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.db import models
from pay.manager import SettlementExtraManager
from api.models import Settlement

__all__ = ['SettlementExtra']


class SettlementExtra(models.Model):
    class Meta:
        db_table = 'pay_settlementextra'
        app_label = 'pay'

    settlement = models.OneToOneField(Settlement, verbose_name='结算单')
    idfa = models.CharField(max_length=64, verbose_name='设备id')
    idfv = models.CharField(max_length=64, verbose_name='设备id')
    current_city_id = models.CharField(max_length=40, verbose_name='current_city_id')
    channel = models.CharField(max_length=40, verbose_name='channel')

    objects = SettlementExtraManager()
