# coding=utf-8
from __future__ import unicode_literals, absolute_import
from hashlib import md5
import types
from django.conf import settings

from pay.models.wechat import Wechat

WECHAT_OBJ_NAME_FOR_MWEB = 'mweb'
WECHAT_OBJ_NAME_FOR_APP = 'app'
WECHAT_OBJ_NAME_FOR_WECHAT_APP = 'wechat_app'


def get_wechat_obj_name_by_appid(appid):
    if appid == settings.CLIENT_WECHAT_APP_ID:
        name = WECHAT_OBJ_NAME_FOR_APP
    elif appid == settings.M_WECHAT_APP_ID:
        name = WECHAT_OBJ_NAME_FOR_MWEB
    elif appid == settings.WXAPP_WECHAT_APP_ID:
        name = WECHAT_OBJ_NAME_FOR_WECHAT_APP
    else:
        raise ValueError("unknown wechat_app_id :" + appid)

    return name


def get_wechat_obj_by_name(wechat_obj_name):
    if wechat_obj_name == WECHAT_OBJ_NAME_FOR_MWEB:
        wechat_obj = Wechat(settings.M_WECHAT_APP_ID, settings.M_WECHAT_PARTNER_ID, settings.M_WECHAT_SECRET)
        wechat_obj.set_cert(settings.M_WECHAT_PEM_KEY, settings.M_WECHAT_PEM_CERT)

    elif wechat_obj_name == WECHAT_OBJ_NAME_FOR_APP:
        wechat_obj = Wechat(settings.CLIENT_WECHAT_APP_ID, settings.CLIENT_WECHAT_PARTNER_ID,
               settings.CLIENT_WECHAT_SECRET)
        wechat_obj.set_cert(settings.CLIENT_WECHAT_PEM_KEY, settings.CLIENT_WECHAT_PEM_CERT)

    elif wechat_obj_name == WECHAT_OBJ_NAME_FOR_WECHAT_APP:
        wechat_obj = Wechat(settings.WXAPP_WECHAT_APP_ID, settings.WXAPP_WECHAT_PARTNER_ID,
                            settings.WXAPP_WECHAT_SECRET)
        wechat_obj.set_cert(settings.WXAPP_WECHAT_PEM_KEY, settings.WXAPP_WECHAT_PEM_CERT)

    else:
        raise ValueError("unknown wechat_obj_name :" + wechat_obj_name)

    return wechat_obj


def get_wechat_obj_new_by_appid(appid):
    if appid == settings.NEW_WXAPP_WECHAT_APP_ID:
        return get_wechat_obj_new_wechat_app()
    elif appid == settings.NEW_CLIENT_WECHAT_APP_ID:
        return get_wechat_obj_new_client_app()
    elif appid == settings.NEW_M_WECHAT_APP_ID:
        return get_wechat_obj_new_mweb()
    else:
        raise ValueError("unknown appid :" + appid)


def get_wechat_obj_new_wechat_app():
    wechat_obj = Wechat(settings.NEW_WXAPP_WECHAT_APP_ID, settings.NEW_WXAPP_WECHAT_PARTNER_ID,
                        settings.NEW_WXAPP_WECHAT_SECRET)
    wechat_obj.set_cert(settings.NEW_WXAPP_WECHAT_PEM_KEY, settings.NEW_WXAPP_WECHAT_PEM_CERT)
    return wechat_obj


def get_wechat_obj_new_client_app():
    wechat_obj = Wechat(settings.NEW_CLIENT_WECHAT_APP_ID, settings.NEW_CLIENT_WECHAT_PARTNER_ID,
                        settings.NEW_CLIENT_WECHAT_SECRET)
    wechat_obj.set_cert(settings.NEW_CLIENT_WECHAT_PEM_KEY, settings.NEW_CLIENT_WECHAT_PEM_CERT)
    return wechat_obj

def get_wechat_obj_new_mweb():
    wechat_obj = Wechat(settings.NEW_M_WECHAT_APP_ID, settings.NEW_M_WECHAT_PARTNER_ID, settings.NEW_M_WECHAT_SECRET)
    wechat_obj.set_cert(settings.NEW_M_WECHAT_PEM_KEY, settings.NEW_M_WECHAT_PEM_CERT)

    return wechat_obj