# -*- coding: UTF-8 -*-

import os
import sys

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "gaia.settings")
import django
django.setup()

from api.models import *

from talos.models.diary import Diary
from hera.viewmodels.tasks import handle_viewmodel_sync
from hera.viewmodels.diary import DiaryVM


def scan_diary():
    vm_cls = DiaryVM
    diaries = Diary.objects.order_by('-id').values_list('id', flat=True)

    bgn = 0
    step = 100
    cnt = diaries.count()

    while bgn < cnt:
        diary_ids = diaries[bgn: bgn + step]
        handle_viewmodel_sync.delay(vm_cls, diary_ids)
        print vm_cls, diary_ids

        bgn += step


if __name__ == '__main__':
    scan_diary()
