# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


import gm_logging.utils
from gm_logging import RequestInfo, RequestInfoExtractor


class GaiaRequestInfoExtractor(object):

    def __init__(self):
        super(GaiaRequestInfoExtractor, self).__init__()
        self._host_ip = gm_logging.utils.get_local_ip()
        self._hostname = gm_logging.utils.get_hostname()

    def get_request_info(self, request):
        request_info = RequestInfo.create(
            log_host=self._host_ip,
            hostname=self._hostname,

            user_id=request.context.session.user_id,

            module='gaia',

            http_verb='GAIA',
            action=request.method,
        )
        if request.environment:
            client_info = request.environment.get('client_info')
            if client_info:
                request_info.set_previous_client_info(client_info)
        return request_info
