# coding=utf-8
import json
from django.test import TestCase

# Create your tests here.


class RPCTestCase(TestCase):
    def call(self, method, params, session_key=None):
        payload = {
            "method": method,
            "params": json.dumps(params)
        }
        if session_key:
            payload['session_key'] = session_key
        r = self.client.post("/api/once", data=payload)
        return json.loads(r.content)

    def multi_call(self, *args):
        payload = {
            "requests": json.dumps(args)
        }
        r = self.client.post("/api/batch", data=payload)
        return json.loads(r.content)

