-- Deploy gaia:2018_06_22_create_weikuan_hospitalpay to mysql

BEGIN;
CREATE TABLE `weikuan_hospital_pay` (
    `id` varchar(12) NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL UNIQUE,
    `status` varchar(2) NOT NULL,
    `total_fee` integer NOT NULL,
    `channel` varchar(2),
    `period` varchar(2),
    `out_trade_no` varchar(32),
    `transaction_id` varchar(50) UNIQUE,
    `account_name` varchar(100),
    `pay_start_time` datetime(6),
    `paid_time` datetime(6),
    `refund_time` datetime(6),
    `account_seller_id` varchar(100) NOT NULL,
    `notify_data` longtext,
    `create_at` datetime(6) NOT NULL
)
;
ALTER TABLE `weikuan_hospital_pay` ADD CONSTRAINT `order_id_refs_id_10c4db91` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
CREATE TABLE `weikuan_hospital_pay_operation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_pay_id` varchar(12) NOT NULL,
    `operator_id` char(32) NOT NULL,
    `optype` integer NOT NULL,
    `role` integer NOT NULL,
    `source` varchar(1) NOT NULL,
    `operate_at` datetime(6)
)
;
ALTER TABLE `weikuan_hospital_pay_operation` ADD CONSTRAINT `hospital_pay_id_refs_id_50583692` FOREIGN KEY (`hospital_pay_id`) REFERENCES `weikuan_hospital_pay` (`id`);
ALTER TABLE `weikuan_hospital_pay_operation` ADD CONSTRAINT `operator_id_refs_id_77d6a533` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);
CREATE INDEX `weikuan_hospital_pay_operation_0c789921` ON `weikuan_hospital_pay_operation` (`hospital_pay_id`);
CREATE INDEX `weikuan_hospital_pay_operation_5e7ba3ec` ON `weikuan_hospital_pay_operation` (`operator_id`);

COMMIT;