-- Deploy gaia:2020-03-02_add_tag_relevant_table to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_servicenewtag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `api_servicenewtag` ADD CONSTRAINT `service_id_refs_id_41a08dd8` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_servicenewtag` ADD CONSTRAINT `tag_id_refs_id_f44c6426` FOREIGN KEY (`tag_id`) REFERENCES `api_tag_3_0` (`id`);


CREATE TABLE `api_specialseckillbutton_new_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `specialseckillbutton_id` integer NOT NULL,
    `tagv3_id` integer NOT NULL,
    UNIQUE (`specialseckillbutton_id`, `tagv3_id`)
)
;
ALTER TABLE `api_specialseckillbutton_new_tags` ADD CONSTRAINT `tagv3_id_refs_id_f90eb496` FOREIGN KEY (`tagv3_id`) REFERENCES `api_tag_3_0` (`id`);

CREATE TABLE `api_new_category_new_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `newcategory_id` integer NOT NULL,
    `tagv3_id` integer NOT NULL,
    UNIQUE (`newcategory_id`, `tagv3_id`)
)
;
ALTER TABLE `api_new_category_new_tags` ADD CONSTRAINT `tagv3_id_refs_id_8595f9c9` FOREIGN KEY (`tagv3_id`) REFERENCES `api_tag_3_0` (`id`);

CREATE TABLE `api_special_new_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `special_id` integer NOT NULL,
    `tagv3_id` integer NOT NULL,
    UNIQUE (`special_id`, `tagv3_id`)
)
;
ALTER TABLE `api_special_new_tag` ADD CONSTRAINT `tagv3_id_refs_id_1ef1ee97` FOREIGN KEY (`tagv3_id`) REFERENCES `api_tag_3_0` (`id`);
ALTER TABLE `api_special_new_tag` ADD CONSTRAINT `special_id_refs_id_64273fd6` FOREIGN KEY (`special_id`) REFERENCES `api_special` (`id`);
CREATE INDEX `api_special_new_tag_57902095` ON `api_special_new_tag` (`special_id`);
CREATE INDEX `api_special_new_tag_4af38d03` ON `api_special_new_tag` (`tagv3_id`);

CREATE TABLE `api_specialrelatedtagv3` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `special_id` integer NOT NULL,
    `tagv3_id` integer NOT NULL,
    `floor_id` integer NOT NULL,
    UNIQUE (`special_id`, `tagv3_id`, `floor_id`)
)
;
ALTER TABLE `api_specialrelatedtagv3` ADD CONSTRAINT `special_id_refs_id_69371bcd` FOREIGN KEY (`special_id`) REFERENCES `api_special` (`id`);
ALTER TABLE `api_specialrelatedtagv3` ADD CONSTRAINT `tagv3_id_refs_id_340302f8` FOREIGN KEY (`tagv3_id`) REFERENCES `api_tag_3_0` (`id`);
CREATE INDEX `api_specialrelatedtagv3_57902095` ON `api_specialrelatedtagv3` (`special_id`);
CREATE INDEX `api_specialrelatedtagv3_4af38d03` ON `api_specialrelatedtagv3` (`tagv3_id`);



COMMIT;
