-- Deploy gaia:20200302_add_app_config to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_app_config` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(64) NOT NULL DEFAULT '' COMMENT '配置名称',
  `key` VARCHAR(64) NOT NULL DEFAULT ''  COMMENT '配置关键字',
  `value` TEXT COMMENT '配置内容',
  `value_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '内容类型',
  `is_online` BOOLEAN NOT NULL default false COMMENT '是否上线',
  `online_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `offline_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_idx_api_app_config_key` (`key`),
  KEY `idx_api_app_config_name` (`name`),
  KEY `idx_api_app_config_online_offline_time` (`is_online`, `online_time`,`offline_time`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='应用配置内容';

COMMIT;
