-- Deploy gaia:20200713__add_plastics_3_0 to mysql

BEGIN;

-- XXX Add DDLs here.

CREATE TABLE `cheek_style` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '风格脸名称',
  `image_url` varchar(512) NOT NULL DEFAULT '' COMMENT '风格脸配置图',
  `is_online` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否在线',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_cheek_is_online_name` (`is_online`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='风格脸';



CREATE TABLE `point_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '绝对值名称',
  `gold_percent_define_id` int(11) NOT NULL  COMMENT '黄金比例值定义id',
  `point_one` int(8) NOT NULL DEFAULT -1 COMMENT '点位1',
  `point_one_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '点位1类型',
  `point_two` int(8) NOT NULL DEFAULT -1 COMMENT '点位2',
  `point_two_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '点位2类型',
  `point_three` int(8) NOT NULL DEFAULT -1 COMMENT '点位3',
  `point_three_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '点位3类型',
  `point_max_diff_value` FLOAT(8) NOT NULL DEFAULT 0 COMMENT '点位最大差值',
  `included_angle_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '夹角类型',
  `is_denominator` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否是分母',
  `is_special` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否是特殊规则',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_point_location_gold_percent_define_id` (`gold_percent_define_id`),
  KEY `idx_point_location_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='点位信息';



CREATE TABLE `gold_skin_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gold_percent_define_id` int(11) NOT NULL  COMMENT '黄金比例值定义id',
  `skin_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '肤质类型',
  `skin_type_max_diff_value` FLOAT(8) NOT NULL DEFAULT 0 COMMENT '肤质最大差值',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_gold_skin_info_gold_percent_define_id` (`gold_percent_define_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='美学肤质';



CREATE TABLE `gold_percent_define` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(64) NOT NULL  COMMENT '美学值关键字',
  `name` varchar(128) NOT NULL  COMMENT '美学值名称',
  `define_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '定义类型',
  `is_online` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否在线',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_gold_percent_define_is_online_name` (`is_online`, `name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='美学比值例定义';


CREATE TABLE `cheek_style_sample` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cheek_style_id` int(11) NOT NULL  COMMENT '风格脸id',
  `image_url` VARCHAR(512) NOT NULL DEFAULT "" COMMENT '风格脸模板图片',
  `is_sample` tinyint(4) NOT NULL DEFAULT 1 COMMENT '是否为样本 1：是  0：不是',
  `discern_status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '样本是否调用 人脸识别接口',
  `deleted` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否被删除',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_cheek_style_sample_deleted_cheek_style_id_is_sample` (`deleted`, `cheek_style_id`, `is_sample`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='风格脸样本库';


CREATE TABLE `face_gold_value` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cheek_style_sample_id` int(11)  NOT NULL COMMENT '风格脸样本库',
  `gold_percent_define_id` int(11) NOT NULL DEFAULT 0 COMMENT '黄金比例值定义id',
  `percent_value` float(11) not null default 0 comment '美学值',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_face_gold_value_cheek_style_sample_id` (`cheek_style_sample_id`),
  KEY `idx_face_gold_value_gpd_id_css_id` (`gold_percent_define_id`, `cheek_style_sample_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='风格脸黄金比例值';



CREATE TABLE `feature_scope_section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `secondary_demand_id` int(11)  NOT NULL COMMENT '二级诉求id',
  `secondary_demand_name` varchar(64)  NOT NULL default "" COMMENT '二级诉求名称',
  `unit` tinyint(4)  NOT NULL default 0 COMMENT '单位',
  `tag_ids` Text  COMMENT '项目标签ids（tag_v3）json dumps',
  `x_value` FLOAT(8) NOT NULL DEFAULT 0 COMMENT 'x的值',
  `y_value` FLOAT(8) NOT NULL DEFAULT 0 COMMENT 'y的值',
  `weight` FLOAT(8) NOT NULL DEFAULT 0 COMMENT '权重',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_feature_scope_section_secondary_demand_id` (`secondary_demand_id`),
  KEY `idx_feature_scope_section_secondary_demand_name` (`secondary_demand_name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='二级诉求标签特征幅度区间';


COMMIT;
