-- Deploy gaia:20200907_search_add_recommend_words to mysql

BEGIN;

-- XXX Add DDLs here.


CREATE TABLE `word_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否被删除',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='搜索词分组';


CREATE TABLE `recommend_words` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `word_group_id` int(11) NOT NULL COMMENT '词组id',
  `thesaurus` varchar(64) NOT NULL DEFAULT '' COMMENT '同义词',
  `is_kernel` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否是核心词',
  `is_deleted` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否被删除',
  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `idx_recommend_words_thesaurus_is_deleted` (`thesaurus`, `is_deleted`),
  KEY `idx_recommend_words_word_group_id_is_deleted` (`word_group_id`, `is_deleted`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='搜索关联词管理';

COMMIT;
