-- Deploy gaia:clue_strategy to mysql

BEGIN;
-- XXX Add DDLs here.
CREATE TABLE `sl_strategy_op_to_tag3rank_d` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `day_id` DATE NOT NULL COMMENT '账期日',
  `project_tag3_id` BIGINT(11) NOT NULL COMMENT '三级标签ID',
  `order_num_30d` BIGINT(20) NOT NULL COMMENT '销量-近30天支付或验证的订单',
  `service_5level_evaluate_30d_rate` double(10,4) NOT NULL COMMENT '5星好评率-近30天支付或验证的美购历史所有评价',
  `project_tag3_score` double(10,4) NOT NULL COMMENT '一级方案排行分值=a*（好评率/所有一级方案平均好评率）+b*（销量/所有一级方案平均销量)',
  `ranking_list_score` double(10,4) NOT NULL COMMENT '排行榜排行分值=好评率/所有一级方案平均好评率',
  `hot_list_score` double(10,4) NOT NULL COMMENT '热门榜排行分值=销量/所有一级方案平均销量',
  PRIMARY KEY `id` (`id`),
  KEY `day_id` (`day_id`),
  UNIQUE KEY `day_project_tag3_unique` (`day_id`, `project_tag3_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `sl_strategy_op_co_hospitalclue_d` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `day_id` DATE NOT NULL COMMENT '账期日',
  `hospital_id` VARCHAR(100) NOT NULL COMMENT '医院ID',
  `clue_num_30d` BIGINT(20) NOT NULL COMMENT '近30天线索数量',
  PRIMARY KEY `id` (`id`),
  KEY `day_id` (`day_id`),
  UNIQUE KEY `day_hospital_unique` (`day_id`, `hospital_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


CREATE TABLE `clue_doctor_smart_rank` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` VARCHAR(100) NOT NULL,
  `smart_rank` float(10,2) NOT NULL,
  PRIMARY KEY `id` (`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
COMMIT;

